/**
 @file		main.c
 @brief 		DNS source ( for W5100 @ Atmega128)
 			Optimized compiler : WinAVR-20071221
 */
 

#include <avr/io.h>
#include <avr/interrupt.h>
//#include <avr/signal.h>
#include <avr/eeprom.h>
#include <stdio.h> 
#include <string.h>

#include "types.h"

#include "delay.h"
#include "mcu.h"

#include "serial.h"
#include "sockutil.h"
#include "socket.h"
//#include "timer.h"
#include "dns.h"

#include "w5100.h"

/*
********************************************************************************
Define Part
********************************************************************************
*/
#define DEFAULT_NET_MEMALLOC	0x55		/**< Default iinchip memory allocation */

#define LED_AVR_PORT_VAL	PORTG
#define LED_AVR_PORT_DIR	DDRG

#define LED_PIN_0			3
#define LED_PIN_1			4

/*
********************************************************************************
Local Variable Declaration Section
********************************************************************************
*/
u_char URL[] = "www.wiznet.co.kr";
extern u_long dns_server_ip;		/**< instead of "NETCONF" */

/*
*******************************************************************************
Function Prototype Declaration Part
*******************************************************************************
*/
static void led_off(u_char led);
static void led_on(u_char led);
static void led_init(void);
static void SetIP(void);

/*
********************************************************************************
Function Implementation Part
********************************************************************************
*/
static void led_off(u_char led)
{
	LED_AVR_PORT_VAL &= ~(1 << (LED_PIN_0+led));
}

static void led_on(u_char led)
{
	LED_AVR_PORT_VAL |= (1 << (LED_PIN_0+led));
}

static void led_init(void)
{
	u_int i;
	
	LED_AVR_PORT_DIR |= (1<<LED_PIN_0) | (1<<LED_PIN_1);
	for(i = 0; i < 5; i++)
	{
		led_on(0);
		led_on(1);
		wait_10ms(50);
		led_off(0);
		led_off(1);
		wait_10ms(50);
	}
}


/**
 @brief 	set the IP, subnet, gateway address
 */
static void SetIP(void)
{
	u_char ip[6];

	// MAC address
	ip[0] = 0x00; ip[1] = 0x08; ip[2] = 0xDC; ip[3] = 0x00; ip[4] = 0x00; ip[5] = 0x4F;
	setSHAR( ip );

	// subnet mask
	ip[0] = 255;ip[1] = 255;ip[2] = 255;ip[3] = 224;
	setSUBR( ip );

	// gateway address
	ip[0] = 211;ip[1] = 46;ip[2] = 117;ip[3] = 94;
	setGAR( ip );

	// ip address
	ip[0] = 211;ip[1] = 46;ip[2] = 117;ip[3] = 80;
	setSIPR( ip );

	// Set DNS server IP address
	dns_server_ip = htonl(inet_addr((u_char*) "168.126.63.1" ));

}


/**
	@mainpage	W5100 Firmware Source for DNS
	@section intro	Introduction
	- Introduction : supported DNS
	@section CREATEINFO	Author
	- author : www.wiznet.co.kr
	- date : 2007.1.2
*/
int main(void)
{
	u_long wiznet_ip = 0;
	
	mcu_init();
	uart_init(0,7);
	
	printf("\r\n*** DNS Test using W5100 ");
#if (__DEF_IINCHIP_BUS__ == __DEF_IINCHIP_DIRECT_MODE__)
	printf("[DIRECT MODE]");
#elif(__DEF_IINCHIP_BUS__ == __DEF_IINCHIP_INDIRECT_MODE__)	/* INDIRECT MODE I/F */
	printf("[INDIRECT MODE]");
#elif (__DEF_IINCHIP_BUS__ == __DEF_IINCHIP_SPI_MODE__)
	printf("[SPI MODE]");
#else
	#error "unknown bus type"
#endif	
	printf(" ***\r\n");

	printf("******* Firmware Version : %d.%d.%d.%d *******\r\n",
			(u_char)(FW_VERSION>>24),
			(u_char)(FW_VERSION>>16),
			(u_char)(FW_VERSION>>8),
			(u_char)(FW_VERSION) );
		
	wait_10ms(100);
	
	led_init();
	iinchip_init();

	// Set IP, subnet, gateway address
	SetIP();
#ifdef __DEF_IINCHIP_INT__
	setIMR(0xEF);
#endif	
	sysinit(DEFAULT_NET_MEMALLOC,DEFAULT_NET_MEMALLOC);

	if ( (wiznet_ip = gethostbyname((char*)URL)) != 0 )
	{
		printf("www.wiznet.co.kr => %s", inet_ntoa( htonl(wiznet_ip) ) );
	}
	else
	{
		printf("Can'g get IP Address.\r\n");
	}
	printf("\r\n*** THANK YOU ***\r\n");
	
	while(1);
	
}


