/**
 @file		mcu_define.h
 */

#ifndef __MCU_DEFINE_H__
#define __MCU_DEFINE_H__


#define __MCU_AVR__	1
#define __MCU_TYPE__	__MCU_AVR__

//---- Refer "Rom File Maker Manual Vx.x.pdf"
#include <avr/pgmspace.h>

#define	_ENDIAN_LITTLE_	0	/**<  This must be defined if system is little-endian alignment */
#define	_ENDIAN_BIG_		1
#define 	SYSTEM_ENDIAN		_ENDIAN_LITTLE_

#define	MAX_SOCK_NUM		4	/**< Maxmium number of socket  */
#define	CLK_CPU			8000000		/**< 8Mhz(for serial) */

/* ## __DEF_IINCHIP_xxx__ : define option for iinchip driver *****************/
//#define __DEF_IINCHIP_DBG__ /* involve debug code in driver (socket.c) */
#define __DEF_IINCHIP_INT__ /**< involve interrupt service routine (socket.c) */
//#define __DEF_IINCHIP_PPP__ /* involve pppoe routine (socket.c) */
                            /* If it is defined, the source files(md5.h,md5.c) must be included in your project.
                               Otherwize, the source files must be removed in your project. */

#define __DEF_IINCHIP_DIRECT_MODE__ 1
#define __DEF_IINCHIP_INDIRECT_MODE__ 2
#define __DEF_IINCHIP_SPI_MODE__ 3
#define __DEF_IINCHIP_BUS__ __DEF_IINCHIP_DIRECT_MODE__
//#define __DEF_IINCHIP_BUS__ __DEF_IINCHIP_INDIRECT_MODE__
//#define __DEF_IINCHIP_BUS__ __DEF_IINCHIP_SPI_MODE__ /*Enable SPI_mode*/


/**
@brief	 __DEF_IINCHIP_MAP_xxx__ : define memory map for iinchip 
*/
#define __DEF_IINCHIP_MAP_BASE__ 0x8000
#if (__DEF_IINCHIP_BUS__ == __DEF_IINCHIP_DIRECT_MODE__)
 #define COMMON_BASE __DEF_IINCHIP_MAP_BASE__
#else
 #define COMMON_BASE 0x0000
#endif
#define __DEF_IINCHIP_MAP_TXBUF__ (COMMON_BASE + 0x4000) /* Internal Tx buffer address of the iinchip */
#define __DEF_IINCHIP_MAP_RXBUF__ (COMMON_BASE + 0x6000) /* Internal Rx buffer address of the iinchip */


#if (__MCU_TYPE__ == __MCU_AVR__)
   #ifdef __DEF_IINCHIP_INT__
      // iinchip use external interrupt 4
      #define IINCHIP_ISR_DISABLE()	(EIMSK &= ~(0x10))
      #define IINCHIP_ISR_ENABLE()	(EIMSK |= 0x10)
      #define IINCHIP_ISR_GET(X)		(X = EIMSK)
      #define IINCHIP_ISR_SET(X)		(EIMSK = X)
   #else
      #define IINCHIP_ISR_DISABLE()
      #define IINCHIP_ISR_ENABLE()	
      #define IINCHIP_ISR_GET(X)
      #define IINCHIP_ISR_SET(X)
   #endif
#else
#error "unknown MCU type"
#endif
#endif
