/*

chargen.h - Character generator service

Listen on port 19, and upon connection send boilerplate text.
https://en.wikipedia.org/wiki/Character_Generator_Protocol

*/

#ifndef CHARGEN_H
#define	CHARGEN_H

/*...sincludes:0:*/
#include "types.h"
#include "net.h"

/*...vtypes\46\h:0:*/
/*...vnet\46\h:0:*/
/*...e*/

#define	CHARGEN_PORT 19

#define	CHARGEN_CHARS    72
#define	CHARGEN_BUF_SIZE (CHARGEN_CHARS+1+1)

typedef struct
	{
	SOCKET_ALLOC socket_alloc;
	byte buf[CHARGEN_BUF_SIZE];
	byte start;
	} CHARGEN;	

extern void chargen_start(CHARGEN *chargen);
extern void chargen_init(void);

#endif
