/*

cpmio.h - CP/M file I/O routines

*/

#ifndef CPMIO_H
#define	CPMIO_H

typedef struct
	{
	char drive;
	char filename[8];
	char type[3];
	unsigned char ex;
	unsigned char s1;
	unsigned char s2;
	unsigned char rc;
	unsigned char al[16];
	unsigned char cr;
	unsigned char r0;
	unsigned char r1;
	unsigned char r2;
	} FCB;

typedef struct
	{
	char drive;
	char filename[8];
	char type[3];
	unsigned char pad[20];
	} DIRENT;

#define	FCB_ADDR1 ((FCB*)0x005c)
#define	FCB_ADDR2 ((FCB*)0x006c)

/* print $ terminated string */
extern void bdos_printf(const char *str);

extern void bdos_set_dma_address(void *addr);

extern void bdos_reset_disc_drives(void);

/* set ex=s1=s2=rc=0 before calling */ 
extern unsigned char bdos_open_file(FCB *fcb);

/* best to set ex=s1=s2=rc=0 before calling */ 
extern unsigned char bdos_create_file(FCB *fcb);

extern unsigned char bdos_read_file(FCB *fcb);

extern unsigned char bdos_write_file(FCB *fcb);

extern unsigned char bdos_close_file(FCB *fcb);

extern unsigned char bdos_delete_files(FCB *fcb);

extern unsigned char bdos_rename_file(FCB *fcb);

/* set drive=ex=0 before calling.
   these return 0-3 if successful, and this is the
   index of a DIRENT in the DMA area. */

extern unsigned char bdos_search_for_first(FCB *fcb);
/* pass same fcb
   same return. */
extern unsigned char bdos_search_for_next(FCB *fcb);
	
#endif
