;
; cpmio.s - CP/M file I/O routines
;
        .module cpmio

bdos =		0x0005

b_printf =	0x09
b_setdma =	0x1a
b_resdsc =	0x0d
b_open =	0x0f
b_create =	0x16
b_read =	0x14
b_write =	0x15
b_close =	0x10
b_delete =	0x13
b_rename =	0x17
b_sff =		0x11
b_sfn =		0x12

        .area   _CODE

; calling BDOS with parameter DE is such a common thing
bdos_de:
	pop	hl
	pop	de
	push	de
	push	hl
	call	#bdos
	ld	l,a
	ret

; void bdos_printf(const char *str)
_bdos_printf::
	ld	c,#b_printf
	jp	bdos_de

; void bdos_set_dma_address(void *addr)
_bdos_set_dma_address::
	ld	c,#b_setdma
	jp	bdos_de

; void bdos_reset_disc_drives(void)
_bdos_reset_disc_drives::
	ld	c,#b_resdsc
	jp	bdos

; unsigned char bdos_open_file(FCB *fcb)
_bdos_open_file::
	ld	c,#b_open
	jp	bdos_de

; unsigned char bdos_create_file(FCB *fcb)
_bdos_create_file::
	ld	c,#b_create
	jp	bdos_de

; unsigned char bdos_read_file(FCB *fcb)
_bdos_read_file::
	ld	c,#b_read
	jp	bdos_de

; unsigned char bdos_write_file(FCB *fcb)
_bdos_write_file::
	ld	c,#b_write
	jp	bdos_de

; unsigned char bdos_close_file(FCB *fcb)
_bdos_close_file::
	ld	c,#b_close
	jp	bdos_de

; unsigned char bdos_delete_files(FCB *fcb)
_bdos_delete_files::
	ld	c,#b_delete
	jp	bdos_de

; unsigned char bdos_rename_file(FCB *fcb)
_bdos_rename_file::
	ld	c,#b_rename
	jp	bdos_de

; unsigned char bdos_search_for_first(FCB *fcb)
_bdos_search_for_first::
	ld	c,#b_sff
	jp	bdos_de

; unsigned char bdos_search_for_next(FCB *fcb)
_bdos_search_for_next::
	ld	c,#b_sfn
	jp	bdos_de
