/*

echo.c - Echo service

*/

/*...sincludes:0:*/
#include <stdio.h>
#include "types.h"
#include "fiber.h"
#include "cpmio.h"
#include "net.h"
#include "echo.h"

/*...vtypes\46\h:0:*/
/*...vfiber\46\h:0:*/
/*...vcpmio\46\h:0:*/
/*...vnet\46\h:0:*/
/*...vecho\46\h:0:*/
/*...e*/

static void echo_listen(ECHO *echo);
static void echo_received(ECHO *echo);

/*...secho_disconnect:0:*/
static void echo_disconnect(ECHO *echo)
	{
	SOCKET *socket = echo->socket_alloc.socket;
	bdos_printf("echo_disconnect:\r\n$");
	net_disconnect(socket, (NF)echo_listen, echo);
	}		
/*...e*/
/*...secho_sent:0:*/
static void echo_sent(ECHO *echo)
	{
	SOCKET *socket = echo->socket_alloc.socket;
	if ( socket->state == SS_ERROR )
		echo_disconnect(echo);
	else
		net_recv(socket, echo->buf, ECHO_BUF_SIZE, (NF)echo_received, echo);
	}		
/*...e*/
/*...secho_received:0:*/
static void echo_received(ECHO *echo)
	{
	SOCKET *socket = echo->socket_alloc.socket;
	if ( socket->state == SS_ERROR )
		echo_disconnect(echo);
	else
		net_send(socket, echo->buf, socket->actual, (NF)echo_sent, echo);
	}
/*...e*/
/*...secho_connected:0:*/
static void echo_connected(ECHO *echo)
	{
	SOCKET *socket = echo->socket_alloc.socket;
	bdos_printf("echo_connected:\r\n$");
	net_recv(socket, echo->buf, ECHO_BUF_SIZE, (NF)echo_received, echo);
	}
/*...e*/
/*...secho_listen:0:*/
static void echo_listen(ECHO *echo)
	{
	SOCKET *socket = echo->socket_alloc.socket;
	bdos_printf("echo_listen:\r\n$");
	net_listen(socket, ECHO_PORT, (NF)echo_connected, echo);
	}
/*...e*/
/*...secho_start:0:*/
void echo_start(ECHO *echo)
	{
	net_alloc(&(echo->socket_alloc), (NF)echo_listen, echo);
	}
/*...e*/
/*...secho_init:0:*/
void echo_init(void)
	{
	}
/*...e*/
