/*

fiber.h - Fibers

The unit of execution.

*/

#ifndef FIBER_H
#define	FIBER_H

typedef void (*NF)(void*);

typedef struct _FIBER FIBER;
struct _FIBER
	{
	FIBER	*next;
	NF	nf;
	void	*nfp;
	};

void fiber_init(void);

/* called from non-interrupt code, often from a fiber
   interrupts are enabled */
extern void fiber_enqueue(FIBER *f);

/* called from non-interrupt code, not from a fiber
   interrupts are enabled */
extern void fiber_drain(void);

/* interrupt occurred
   interrupts are disabled,
   hardware has been responded to,
   we now need to enqueue a fiber. */
extern void fiber_enqueue_isr(FIBER *f);

/* interrupt occurred
   interrupts are disabled,
   hardware has been responded to,
   fiber(s) have been enqueued,
   we now need the fibers processed. */
extern void fiber_drain_isr(void);

#endif
