/*

http.h - HTTP service

Listen on port 80, and serve HTML.

*/

#ifndef HTTP_H
#define	HTTP_H

/*...sincludes:0:*/
#include "types.h"
#include "net.h"

/*...vtypes\46\h:0:*/
/*...vnet\46\h:0:*/
/*...e*/

#define	HTTP_PORT 80

#define	HTTPLINE_STATE_OK       0
#define	HTTPLINE_STATE_TOO_LONG 1
#define	HTTPLINE_STATE_ERROR    2

typedef struct
	{
	SOCKET *socket;
	byte *buf;
	byte length;
	FIBER fiber;
	byte actual;
	byte state; /* HTTPLINE_STATE_* */
	} HTTPLINE;

#define	HTTPBLOCK_STATE_OK    0
#define	HTTPBLOCK_STATE_ERROR 1

typedef struct
	{
	SOCKET *socket;
	byte *buf;
	FIBER fiber;
	byte length;
	byte actual;
	byte state; /* HTTPBLOCK_STATE_* */
	} HTTPBLOCK;

#define	HTTP_MAX_REQUEST        100 /* <= 255 */
#define	HTTP_MAX_REQUEST_HEADER 255 /* <= 255 */
#define	HTTP_MAX_BUFFER         500 /* >= 128, and >= HTTP_MAX_REQUEST_HEADER */

#define	HTTP_VERB_GET    0
#define	HTTP_VERB_POST   1
#define	HTTP_VERB_DELETE 2

typedef struct
	{
	SOCKET_ALLOC socket_alloc;
	HTTPLINE httpline;
	HTTPBLOCK httpblock;
	byte request[HTTP_MAX_REQUEST];
	FCB fcb;
	byte buffer[HTTP_MAX_BUFFER];
	BOOLEAN textual;
	BOOLEAN allow_post;
	BOOLEAN allow_delete;
	byte verb; /* HTTP_VERB_* */
	dword content_length;
	} HTTP;	

extern void http_start(HTTP *http);
extern void http_init(void);

#endif
