/*

list.c - Singly linked-lists

*/

/*...sincludes:0:*/
#include <stdlib.h>
#include "list.h"

/*...vlist\46\h:0:*/
/*...e*/

/*...slist_init:0:*/
void list_init(LIST *list)
	{
	list->first = NULL;
	list->last = (LINK *) list;
	}
/*...e*/
/*...slist_empty:0:*/
BOOLEAN list_empty(LIST *list)
	{
	return list->first != NULL;
	}
/*...e*/
/*...slist_first:0:*/
void *list_first(LIST *list)
	{
	return list->first;
	}
/*...e*/
/*...slist_next:0:*/
void *list_next(void *elem)
	{
	LINK *link = (LINK *) elem;
	return link->next;
	}
/*...e*/
/*...slist_add_first:0:*/
void list_add_first(LIST *list, void *elem)
	{
	LINK *link = (LINK *) elem;
	link->next = list->first;
	list->first = link;
	if ( list->last == (LINK *) list )
		list->last = link;
	}
/*...e*/
/*...slist_add_last:0:*/
void list_add_last(LIST *list, void *elem)
	{
	LINK *link = (LINK *) elem;
	link->next = NULL;
	list->last->next = link; /* may be list->first */
	list->last = link;
	}
/*...e*/
/*...slist_add_after:0:*/
void list_add_after(LIST *list, void *elem, void *elem_new)
	{
	LINK *link     = (LINK *) elem;
	LINK *link_new = (LINK *) elem_new;
	link_new->next = link->next;
	link->next = link_new;
	if ( list->last == link )
		list->last = link_new;
	}
/*...e*/
/*...slist_remove_first:0:*/
void *list_remove_first(LIST *list)
	{
	LINK *link;
	if ( (link = list->first) != NULL )
		if ( (list->first = link->next) == NULL )
			list->last = (LINK *) list;
	return link;
	}
/*...e*/
