/*

list.h - Singly linked-lists

Any structure which starts with a "next" link can be put in the list.
A structure can obviously only be in at most one list at once.
Can also be used as stack.

*/

#ifndef	LIST_H
#define	LIST_H

#include "types.h"

/*...vtypes\46\h:0:*/

typedef struct _LINK LINK;
struct _LINK
	{
	LINK	*next;
	};

typedef struct
	{
	LINK	*first;
	LINK	*last;
	} LIST;

extern void list_init(LIST *list);
extern BOOLEAN list_empty(LIST *list);
extern void *list_first(LIST *list);
extern void *list_next(void *elem);
extern void list_add_first(LIST *list, void *elem);
extern void list_add_last(LIST *list, void *elem);
extern void list_add_after(LIST *list, void *elem, void *elem_new);
extern void *list_remove_first(LIST *list);

#endif
