/*

mem.h - Memory routines

Uses a reservation verses allocation based scheme.
Asynchronously reserve N blocks, then can alloc upto N synchronously.

*/

#ifndef	MEM_H
#define	MEM_H

/*...sincludes:0:*/
#include "list.h"

/*...vlist\46\h:0:*/
/*...e*/

typedef struct
	{
	unsigned count;
	LIST free;
	LIST waiters;
	} MEM_POOL;

typedef struct
	{
	FIBER fiber;
	unsigned n;
	} MEM_RESERVE;

extern void mem_init_empty(MEM_POOL *mpool);
extern void mem_init(MEM_POOL *mpool, byte *ptr, unsigned n, unsigned size);
extern void mem_reserve(MEM_POOL *mpool, MEM_RESERVE *mres, unsigned n, NF nf, void *nfp);
extern void mem_unreserve(MEM_POOL *mpool, unsigned n);
extern void *mem_alloc(MEM_POOL *mpool);
extern void mem_free(MEM_POOL *mpool, void *ptr);

#endif
