/*

nfx.c - Initialise and start services

*/

/*...sincludes:0:*/
#include <stdio.h>
#include "types.h"
#include "interrupts.h"
#include "fiber.h"
#include "clock.h"
#include "cpmio.h"
#include "net.h"
#include "echo.h"
#include "chargen.h"
#include "http.h"

/*...vtypes\46\h:0:*/
/*...vinterrupts\46\h:0:*/
/*...vfiber\46\h:0:*/
/*...vclock\46\h:0:*/
/*...vcpmio\46\h:0:*/
/*...vnet\46\h:0:*/
/*...vecho\46\h:0:*/
/*...vchargen\46\h:0:*/
/*...vhttp\46\h:0:*/
/*...e*/

static ECHO echo;
static CHARGEN chargen;
static HTTP http1;
static HTTP http2;

static void first(void *nfp)
	{
	nfp=nfp;
	echo_start(&echo);
	chargen_start(&chargen);
	http1.allow_post   = TRUE;
	http1.allow_delete = TRUE;
	http_start(&http1);
	http2.allow_post   = TRUE;
	http2.allow_delete = TRUE;
	http_start(&http2);
	}

static FIBER first_fiber = { NULL, first, NULL };

int main(void)
	{
	bdos_printf("NFX test\r\n$");
	fiber_init();
	clock_init();
	interrupts_enable();
	net_init();
	echo_init();
	chargen_init();
	http_init();
	fiber_enqueue(&first_fiber);
	for ( ;; )
		{
		net_handle_interrupts();
		clock_tick();
		fiber_drain();
		}
	}
