/*

sem.h - Semaphores

Event semaphores: everyone sleeps until wake occurs.
Counting semaphores: at most N requests at once.
Zero semaphores: after N releases, requests are satisfied.

*/

#ifndef SEM_H
#define	SEM_H

/*...sincludes:0:*/
#include "list.h"
#include "fiber.h"

/*...vlist\46\h:0:*/
/*...vfiber\46\h:0:*/
/*...e*/

typedef struct
	{
	LIST waiting;
	} ESEM;

typedef struct
	{
	LIST waiting;
	unsigned count;
	} CSEM;

typedef struct
	{
	LIST waiting;
	unsigned count;
	} ZSEM;

extern void esem_init(ESEM *esem);
extern void esem_sleep(ESEM *esem, FIBER *fiber, NF nf, void *nfp);
extern void esem_wake(ESEM *esem);

extern void csem_init(CSEM *csem, unsigned count);
extern void csem_request(CSEM *csem, FIBER *fiber, NF nf, void *nfp);
extern void csem_release(CSEM *csem);

extern void zsem_init(ZSEM *zsem, unsigned count);
extern void zsem_sleep(ZSEM *zsem, FIBER *fiber, NF nf, void *nfp);
extern void zsem_dec(ZSEM *zsem);

#endif
