/*

w5100.h - W5100 hardware specifics

*/

#ifndef W5100_H
#define W5100_H

/* Areas of memory */
#define W5100_ADDR_COMMON   0x0000
#define	W5100_ADDR_SOCKET   0x0400
#define	W5100_ADDR_SOCKET_0 0x0400
#define	W5100_ADDR_SOCKET_1 0x0500
#define	W5100_ADDR_SOCKET_2 0x0600
#define	W5100_ADDR_SOCKET_3 0x0700
#define	W5100_ADDR_TX       0x4000
#define	W5100_ADDR_RX       0x6000

/* Registers in common area */
#define W5100_ADDR_REG_MODE   0x0000
#define W5100_ADDR_REG_GAR0   0x0001
#define W5100_ADDR_REG_GAR1   0x0002
#define W5100_ADDR_REG_GAR2   0x0003
#define W5100_ADDR_REG_GAR3   0x0004
#define W5100_ADDR_REG_SUBR0  0x0005
#define W5100_ADDR_REG_SUBR1  0x0006
#define W5100_ADDR_REG_SUBR2  0x0007
#define W5100_ADDR_REG_SUBR3  0x0008
#define W5100_ADDR_REG_SHAR0  0x0009
#define W5100_ADDR_REG_SHAR1  0x000a
#define W5100_ADDR_REG_SHAR2  0x000b
#define W5100_ADDR_REG_SHAR3  0x000c
#define W5100_ADDR_REG_SHAR4  0x000d
#define W5100_ADDR_REG_SHAR5  0x000e
#define W5100_ADDR_REG_SIPR0  0x000f
#define W5100_ADDR_REG_SIPR1  0x0010
#define W5100_ADDR_REG_SIPR2  0x0011
#define W5100_ADDR_REG_SIPR3  0x0012
#define W5100_ADDR_REG_IR     0x0015
#define W5100_ADDR_REG_IMR    0x0016
#define W5100_ADDR_REG_RTR0   0x0017
#define W5100_ADDR_REG_RTR1   0x0018
#define W5100_ADDR_REG_RCR    0x0019
#define W5100_ADDR_REG_RMSR   0x001a
#define W5100_ADDR_REG_TMSR   0x001b
#define W5100_ADDR_REG_PATR0  0x001c
#define W5100_ADDR_REG_PATR1  0x001d
#define W5100_ADDR_REG_PTIMER 0x0028
#define W5100_ADDR_REG_PMAGIC 0x0029
#define W5100_ADDR_REG_UIPR0  0x002a
#define W5100_ADDR_REG_UIPR1  0x002b
#define W5100_ADDR_REG_UIPR2  0x002b
#define W5100_ADDR_REG_UIPR3  0x002d
#define W5100_ADDR_REG_UPORT0 0x002e
#define W5100_ADDR_REG_UPORT1 0x002f

/* Mode register bits */
#define	W5100_MR_RESET        0x80
#define	W5100_MR_PING_BLOCK   0x10
#define	W5100_MR_PPPOE_ENABLE 0x08
#define	W5100_MR_INCREMENT    0x02
#define	W5100_MR_INDIRECT     0x01

/* Interrupt bits */
#define	W5100_IR_CONFLICT 0x80
#define	W5100_IR_UNREACH  0x40
#define	W5100_IR_PPPOE    0x20
#define	W5100_IR_RESERVED 0x10
#define	W5100_IR_S3_INT   0x08
#define	W5100_IR_S2_INT   0x04
#define	W5100_IR_S1_INT   0x02
#define	W5100_IR_S0_INT   0x01

/* Socket register offsets */
#define	W5100_OFFSET_SOCKET_MR      0x0000
#define	W5100_OFFSET_SOCKET_CR      0x0001
#define	W5100_OFFSET_SOCKET_IR      0x0002
#define	W5100_OFFSET_SOCKET_SR      0x0003
#define	W5100_OFFSET_SOCKET_PORT0   0x0004
#define	W5100_OFFSET_SOCKET_PORT1   0x0005
#define	W5100_OFFSET_SOCKET_DHAR0   0x0006
#define	W5100_OFFSET_SOCKET_DHAR1   0x0007
#define	W5100_OFFSET_SOCKET_DHAR2   0x0008
#define	W5100_OFFSET_SOCKET_DHAR3   0x0009
#define	W5100_OFFSET_SOCKET_DHAR4   0x000a
#define	W5100_OFFSET_SOCKET_DHAR5   0x000b
#define	W5100_OFFSET_SOCKET_DIPR0   0x000c
#define	W5100_OFFSET_SOCKET_DIPR1   0x000d
#define	W5100_OFFSET_SOCKET_DIPR2   0x000e
#define	W5100_OFFSET_SOCKET_DIPR3   0x000f
#define	W5100_OFFSET_SOCKET_DPORT0  0x0010
#define	W5100_OFFSET_SOCKET_DPORT1  0x0011
#define	W5100_OFFSET_SOCKET_MSSR0   0x0012
#define	W5100_OFFSET_SOCKET_MSSR1   0x0013
#define	W5100_OFFSET_SOCKET_PROTO   0x0014
#define	W5100_OFFSET_SOCKET_TOS     0x0015
#define	W5100_OFFSET_SOCKET_TTL     0x0016
#define	W5100_OFFSET_SOCKET_TX_FSR0 0x0020
#define	W5100_OFFSET_SOCKET_TX_FSR1 0x0021
#define	W5100_OFFSET_SOCKET_TX_RD0  0x0022
#define	W5100_OFFSET_SOCKET_TX_RD1  0x0023
#define	W5100_OFFSET_SOCKET_TX_WR0  0x0024
#define	W5100_OFFSET_SOCKET_TX_WR1  0x0025
#define	W5100_OFFSET_SOCKET_RX_RSR0 0x0026
#define	W5100_OFFSET_SOCKET_RX_RSR1 0x0027
#define	W5100_OFFSET_SOCKET_RX_RD0  0x0028
#define	W5100_OFFSET_SOCKET_RX_RD1  0x0029

/* Socket mode register bits */
#define	W5100_SOCKET_MR_MULTI  0x80
#define	W5100_SOCKET_MR_MF     0x40
#define	W5100_SOCKET_MR_ND     0x20
#define	W5100_SOCKET_MR_PROTO  0x0f
#define	W5100_SOCKET_MR_CLOSED 0x00
#define	W5100_SOCKET_MR_TCP    0x01
#define	W5100_SOCKET_MR_UDP    0x02
#define	W5100_SOCKET_MR_IPRAW  0x03
#define	W5100_SOCKET_MR_MACRAW 0x04
#define	W5100_SOCKET_MR_PPPOE  0x05

/* Socket command register values */
#define	W5100_SOCKET_CR_OPEN      0x01
#define	W5100_SOCKET_CR_LISTEN    0x02
#define	W5100_SOCKET_CR_CONNECT   0x04
#define	W5100_SOCKET_CR_DISCON    0x08
#define	W5100_SOCKET_CR_CLOSE     0x10
#define	W5100_SOCKET_CR_SEND      0x20
#define	W5100_SOCKET_CR_SEND_MAC  0x21
#define	W5100_SOCKET_CR_SEND_KEEP 0x22
#define	W5100_SOCKET_CR_RECV      0x40

/* Socket interrupt register bits */
#define	W5100_SOCKET_IR_SEND_OK 0x10
#define	W5100_SOCKET_IR_TIMEOUT 0x08
#define	W5100_SOCKET_IR_RECV    0x04
#define	W5100_SOCKET_IR_DISCON  0x02
#define	W5100_SOCKET_IR_CON     0x01

/* Socket status register values */
#define	W5100_SOCKET_SR_SOCK_CLOSED      0x00
#define	W5100_SOCKET_SR_SOCK_INIT        0x13
#define	W5100_SOCKET_SR_SOCK_LISTEN      0x14
#define	W5100_SOCKET_SR_SOCK_ESTABLISHED 0x17
#define	W5100_SOCKET_SR_SOCK_CLOSE_WAIT  0x1c
#define	W5100_SOCKET_SR_SOCK_UDP         0x22
#define	W5100_SOCKET_SR_SOCK_IPRAW       0x32
#define	W5100_SOCKET_SR_SOCK_MACRAW      0x42
#define	W5100_SOCKET_SR_SOCK_PPPOE       0x5f
#define	W5100_SOCKET_SR_SOCK_SYNSENT     0x15
#define	W5100_SOCKET_SR_SOCK_SYNRECV     0x16
#define	W5100_SOCKET_SR_SOCK_FIN_WAIT    0x18
#define	W5100_SOCKET_SR_SOCK_CLOSING     0x1a
#define	W5100_SOCKET_SR_SOCK_TIME_WAIT   0x1b
#define	W5100_SOCKET_SR_SOCK_LAST_ACK    0x1d
#define	W5100_SOCKET_SR_SOCK_ARP         0x01

#endif
