/*

wiz.c - Access to WIZnet on NFX

*/

/*...semail from Martin:0:*/
/*

The NFX uses a Wiznet 5100 chip on an adapter board, it's got the 8 bit IDE
on-board and a custom 40 column CP/M.

The Wiznet is mapped a bit like the VDP it has 4 I/O ports A0 to A3. Control,
address msb, address, lsb and data. Although unlike the VDP you can turn the
auto increment on and off as required. Datasheet and rom source code such as
it is enclosed. The interrupt from the net card isn't connected as I couldn't
see a safe way to do it.
 
The IDE is mapped B0-BF
 
There's 3 general routines in the rom:
FFD9 for net init
FFDC for net write
FFDF for net read
  
The wiznet chip memory maps its registers so within the 32k map, the read and
write routines ought to be able to access both the registers and the data ram.
I did manage to set up some test code using an SDX rom to give the board an
IP address so it could respond to pings from a PC. There's only room for one
paged rom as it's using grom to page to rom. I'd decided because it had more
useable memory, CPM would be a better environment to do any more work so
replaced the SDX rom with a CPM one.

*/
/*...e*/

/*...sincludes:0:*/
#include <stdio.h>
#include "w5100.h"
#include "wizio.h"
#include "wiz.h"

/*...vw5100\46\h:0:*/
/*...vwizio\46\h:0:*/
/*...vwiz\46\h:0:*/
/*...e*/

/*...sports:0:*/
#define	NFX_WIZ_CONTROL_PORT  0xa0
#define	NFX_WIZ_ADDR_MSB_PORT 0xa1
#define	NFX_WIZ_ADDR_LSB_PORT 0xa2
#define	NFX_WIZ_DATA_PORT     0xa3
	
__sfr __at NFX_WIZ_CONTROL_PORT  NFX_WIZ_CONTROL ;
__sfr __at NFX_WIZ_ADDR_MSB_PORT NFX_WIZ_ADDR_MSB;
__sfr __at NFX_WIZ_ADDR_LSB_PORT NFX_WIZ_ADDR_LSB;
__sfr __at NFX_WIZ_DATA_PORT     NFX_WIZ_DATA    ;
/*...e*/

#define	USE_WIZIO

/*...swiz_reset:0:*/
void wiz_reset(void)
	{
	/* note: don't use W5100_MR_RESET here */
	NFX_WIZ_CONTROL = W5100_MR_INDIRECT|W5100_MR_INCREMENT;
	}
/*...e*/
/*...swiz_set_addr:0:*/
void wiz_set_addr(word addr)
	{
	NFX_WIZ_ADDR_MSB = (byte) (addr>>8);
	NFX_WIZ_ADDR_LSB = (byte)  addr    ;
	}
/*...e*/
/*...swiz_write:0:*/
void wiz_write(word addr, byte value)
	{
	wiz_set_addr(addr);
	NFX_WIZ_DATA = value;
	}
/*...e*/
/*...swiz_write_word:0:*/
void wiz_write_word(word addr, word ptr)
	{
	wiz_set_addr(addr);
	NFX_WIZ_DATA = (byte) (ptr>>8);
	NFX_WIZ_DATA = (byte)  ptr    ;
	}
/*...e*/
/*...swiz_write_n:0:*/
void wiz_write_n(word addr, const byte *values, word n)
	{
	wiz_set_addr(addr);
#ifdef USE_WIZIO
	wizio_out(values, n, NFX_WIZ_DATA_PORT);
#else
	while ( n-- > 0 )
		NFX_WIZ_DATA = *values++;
#endif
	}
/*...e*/
/*...swiz_read:0:*/
byte wiz_read(word addr)
	{
	wiz_set_addr(addr);
	return NFX_WIZ_DATA;
	}
/*...e*/
/*...swiz_read_word:0:*/
word wiz_read_word(word addr)
	{
	byte r0, r1;
	wiz_set_addr(addr);
	r0 = NFX_WIZ_DATA;
	r1 = NFX_WIZ_DATA;
	return ((word)r0)<<8 | (word)r1;
	}
/*...e*/
/*...swiz_read_n:0:*/
void wiz_read_n(word addr, byte *values, word n)
	{
	wiz_set_addr(addr);
#ifdef USE_WIZIO
	wizio_in(values, n, NFX_WIZ_DATA_PORT);
#else
	while ( n-- > 0 )
		*values++ = NFX_WIZ_DATA;
#endif
	}
/*...e*/
