;
; BOOT ROM configuration
;

; One of these must be selected
CRT80	EQU	0
CRT56	EQU	1

; One of these must be selected
FDXFDC	EQU	0
SDXFDC	EQU	1

; This can be selected
ISIDISC	EQU	1

; At least one of these must be selected
BOOTF50	EQU	0
BOOTF51	EQU	0
BOOTF52	EQU	1
BOOTD13	EQU	0
BOOTE13	EQU	0
BOOTB07	EQU	1
BOOTB03	EQU	0
BOOTC07	EQU	0
BOOTC03	EQU	0

; This can be selected
INITF	EQU	0

; This can be selected
REMCMD	EQU	1

; Set system type
STYPE1	EQU	'S'
STYPE2	EQU	'D'
STYPE3	EQU	'P'

;

	IFT CRT80+CRT56 NE 1
	.PRINTX /!!! Exactly one choice for CRT must be made !!!/
	ENDIF

	IFT FDXFDC+SDXFDC NE 1
	.PRINTF /!!! Exactly one choice for FDC must be made !!!/
	ENDIF

	IFT ( BOOTF50 OR BOOTF51 OR BOOTF52 ) AND ( NOT ISIDISC )
	.PRINTF /!!! Sidisc must be installed to boot from RAM Disc !!!/
	ENDIF

	IFT BOOTF50+BOOTF51+BOOTF52 GT 1
	.PRINTX /!!! At most one choice for F: can be made !!!/
	ENDIF

	IFT INITF AND (BOOTF50+BOOTF51+BOOTF52 EQ 0)
	.PRINTF /!!! Cannot initialise F: if not booting from it !!!/
	ENDIF

	IFT ( BOOTD13 OR BOOTE13 ) AND ( NOT FDXFDC )
	.PRINTF /!!! Only the FDX FDC supports 8" drives !!!/
	ENDIF

	IFT ( BOOTB07 OR BOOTB03 OR BOOTC07 OR BOOTC03 ) AND ( NOT ( FDXFDC OR SDXFDC ) )
	.PRINTF /!!! Only the FDX or SDX FDC supports 3.5" or 5.25" drives !!!/
	ENDIF

	IFT BOOTB07 AND BOOTB03
	.PRINTF /!!! Exactly one choice for B: can be made !!!/
	ENDIF

	IFT BOOTC07 AND BOOTC03
	.PRINTF /!!! Exactly one choice for C: can be made !!!/
	ENDIF

