#!/bin/ksh
#
# memu-test.sh - Test boot ROM
#
# It relies on
#   Bill Brendlings support for larger amounts of memory
#   having appropriate CP/M boot ROM, built for SDX FDC
#   not using the CP/M emulation built into MEMU
#   Bill Brendlings SDX FDC emulation accessing .mfloppy files
#   access to an .mfloppy file of the right type
#

memu \
-mem-blocks 36 \
-addr 0 -mem firmware/OS.BIN \
-tape-disable \
-rom4 firmware/BOOT.BIN \
-rom5 firmware/SDX.BIN \
-mon-ignore-init \
-sdx-mfloppy ../diskimages/games-megastar.mfloppy-07 \
-vid-win-big -snd-portaudio \
"$@"
