#
# ~/terminfo/setup.csh - Setup improved terminal support, for csh/tcsh users
#
# To use this file, add "source ~/terminfo/setup.csh" to your .cshrc file.
# This script recognises system/terminal combinations which have missing or
# poor support and changes the environment to use better versions.
#

if ( $?prompt ) then

	switch ( `uname -s` )
		case AIX:
			switch ( $TERM )
				case vt100:
					# The AIX vt100 definition has no color
					setenv TERM vt100-color
					setenv TERMINFO $HOME/terminfo/`uname -s`
					breaksw
				case linux:
					# AIX has no linux definition
					setenv TERMINFO $HOME/terminfo/`uname -s`
					breaksw
				case LINUX:
					# RedHat gives a funny terminal name
					setenv TERM linux
					setenv TERMINFO $HOME/terminfo/`uname -s`
					breaksw
				case xterm:
					# The AIX xterm definition has no color
					setenv TERM xterm-color
					setenv TERMINFO $HOME/terminfo/`uname -s`
					breaksw
			endsw
			breaksw
		case Linux:
		case HP-UX:
		case SunOS:
			switch ( $TERM )
				case vt100:
					# The Linux vt100 definition has no color
					# The HP-UX vt100 definition has no color
					# The SunOS vt100 definition has no color
					setenv TERM vt100-color
					setenv TERMINFO $HOME/terminfo/Linux
					breaksw
				case hft:
					# The Linux hft definition has no color
					# HP-UX has no hft definition
					# SunOS has no hft definition
					setenv TERMINFO $HOME/terminfo/Linux
					breaksw
				case aixterm:
					# Linux has no aixterm definition
					# The HP-UX aixterm definition is broken
					# SunOS has no aixterm definition
					setenv TERMINFO $HOME/terminfo/Linux
					breaksw
			endsw
			breaksw
	endsw

#	if ( $?TERMINFO ) then
#		echo '$TERMINFO='$TERMINFO '$TERM='$TERM
#	else
#		echo '$TERM='$TERM
#	endif

endif
