#
# ~/terminfo/setup.sh - Setup improved terminal support, for sh users
#
# To use this file, add ". ~/terminfo/setup.sh" to your .bashrc file or similar.
# This script recognises system/terminal combinations which have missing or
# poor support and changes the environment to use better versions.
#

case $- in

	*i*)

		case `uname -s`  in
			AIX)
				case $TERM in
					vt100)
						# The AIX vt100 definition has no color
						TERM=vt100-color
						export TERM
						TERMINFO=$HOME/terminfo/`uname -s`
						export TERMINFO
						;;
					linux)
						# AIX has no linux definition
						TERMINFO=$HOME/terminfo/`uname -s`
						export TERMINFO
						;;
					LINUX)
						# RedHat gives a funny terminal name
						TERM=linux
						export TERM
						TERMINFO=$HOME/terminfo/`uname -s`
						export TERMINFO
						;;
					xterm)
						# The AIX xterm definition has no color
						TERM=xterm-color
						export TERM
						TERMINFO=$HOME/terminfo/`uname -s`
						export TERMINFO
						;;
				esac
				;;
			Linux|HP-UX|SunOS)
				case $TERM in
					vt100)
						# The Linux vt100 definition has no color
						# The HP-UX vt100 definition has no color
						# The SunOS vt100 definition has no color
						TERM=vt100-color
						export TERM
						TERMINFO=$HOME/terminfo/Linux
						export TERMINFO
						;;
					hft)
						# The Linux hft definition has no color
						# HP-UX has no hft definition
						# SunOS has no hft definition
						TERMINFO=$HOME/terminfo/Linux
						export TERMINFO
						;;
					aixterm)
						# Linux has no aixterm definition
						# The HP-UX aixterm definition is broken
						# SunOS has no aixterm definition
						TERMINFO=$HOME/terminfo/Linux
						export TERMINFO
						;;
				esac
				;;
		esac

#		if [ ! -z "$TERMINFO ]; then
#			echo '$TERMINFO='$TERMINFO '$TERM='$TERM
#		else
#			echo '$TERM='$TERM
#		fi

esac
