/*
 * Decompiled with CFR 0.152.
 */
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import nyangau.miniawt.Color;
import nyangau.miniawt.FontMetrics;
import nyangau.miniawt.Frame;
import nyangau.miniawt.Graphics;
import nyangau.miniawt.Image;
import nyangau.miniawt.PngEncoder;

public class TrendServlet
extends HttpServlet {
    protected Object _o_clone_bug = new Object();
    protected int _clone_bug;
    static final int minW = 100;
    static final int defW = 800;
    static final int maxW = 4000;
    static final int minH = 50;
    static final int defH = 200;
    static final int maxH = 2000;
    static final Color colorBitmap = Color.white;
    static final Color colorGraph = Color.lightGray;
    static final Color colorGrid = Color.gray;
    static final Color colorText = Color.black;
    static final Color colorTitleBg = new Color(204, 204, 255);
    static final Color colorSqueezed = Color.red;
    static final Color[] colorConsumers = new Color[]{new Color(204, 0, 0), new Color(0, 204, 204), new Color(0, 204, 0), new Color(204, 0, 204), new Color(0, 0, 204), new Color(204, 204, 0), new Color(102, 0, 0), new Color(0, 102, 102), new Color(0, 102, 0), new Color(102, 0, 102), new Color(0, 0, 102), new Color(102, 102, 0)};
    static final Color[] colorConsumersExceed = new Color[]{new Color(255, 102, 102), new Color(102, 255, 255), new Color(102, 255, 102), new Color(255, 102, 255), new Color(102, 102, 255), new Color(255, 255, 102), new Color(255, 51, 51), new Color(51, 255, 255), new Color(51, 255, 51), new Color(255, 51, 255), new Color(51, 51, 255), new Color(255, 255, 51)};
    static final int mintime = 60000;
    Properties props;
    String name;
    String doclinkname;
    String doclinkurl;
    Vector<String> ds_all;
    int nDatasources;
    Vector<String> r_all;
    int nResources;
    float[] multipliers;
    Dictionary<String, Vector<Sample>> samplesHash = new Hashtable<String, Vector<Sample>>();

    public static String encodeHTML(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        sb.append(c);
                        continue block6;
                    }
                    sb.append("&#");
                    sb.append((int)c);
                    sb.append(";");
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Calendar cloneCalendar(Calendar c) {
        Calendar c2 = (Calendar)c.clone();
        Object object = this._o_clone_bug;
        synchronized (object) {
            this._clone_bug = c.get(5);
        }
        return c2;
    }

    protected static boolean matches(String text, String pattern) {
        if (pattern.equals("")) {
            return text.equals("");
        }
        if (pattern.charAt(0) == '*') {
            return TrendServlet.matches(text, pattern.substring(1)) || !text.equals("") && TrendServlet.matches(text.substring(1), pattern);
        }
        if (pattern.charAt(0) == '?') {
            return !text.equals("") && TrendServlet.matches(text.substring(1), pattern.substring(1));
        }
        return !text.equals("") && pattern.charAt(0) == text.charAt(0) && TrendServlet.matches(text.substring(1), pattern.substring(1));
    }

    protected static int matches(String text, Vector<String> patterns) {
        for (int i = 0; i < patterns.size(); ++i) {
            if (!TrendServlet.matches(text, patterns.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    protected int toInt(String s, int def) {
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    protected float toFloat(String s, float def) {
        if (s == null) {
            return def;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    protected String getInitParameter(String p) {
        String v;
        if (this.props != null && (v = this.props.getProperty(p)) != null) {
            return v;
        }
        ServletConfig sc = this.getServletConfig();
        return sc.getInitParameter(p);
    }

    protected String getInitParameter(String p, String def) {
        String v = this.getInitParameter(p);
        if (v != null) {
            return v;
        }
        return def;
    }

    protected Vector<String> getInitParameterVector(String p) {
        Vector<String> vec = new Vector<String>();
        String v = this.getInitParameter(p);
        if (v != null) {
            StringTokenizer st = new StringTokenizer(v, ",");
            while (st.hasMoreTokens()) {
                vec.add(st.nextToken());
            }
        }
        return vec;
    }

    protected static String cal_to_str(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) - 0 + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return year + "-" + (month < 10 ? "0" : "") + month + "-" + (day < 10 ? "0" : "") + day + "-" + (hour < 10 ? "0" : "") + hour + "-" + (minute < 10 ? "0" : "") + minute + "-" + (second < 10 ? "0" : "") + second;
    }

    protected static String cal_to_str_csv(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2) - 0 + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return year + "-" + (month < 10 ? "0" : "") + month + "-" + (day < 10 ? "0" : "") + day + " " + (hour < 10 ? "0" : "") + hour + ":" + (minute < 10 ? "0" : "") + minute + ":" + (second < 10 ? "0" : "") + second;
    }

    protected static Calendar str_to_cal(String s, String delims) {
        StringTokenizer st = new StringTokenizer(s, delims);
        Calendar cal = Calendar.getInstance();
        try {
            int year = Integer.parseInt(st.nextToken());
            int month = Integer.parseInt(st.nextToken());
            int day = Integer.parseInt(st.nextToken());
            int hour = Integer.parseInt(st.nextToken());
            int minute = Integer.parseInt(st.nextToken());
            int second = Integer.parseInt(st.nextToken());
            cal.clear();
            cal.set(year, month - 1 + 0, day, hour, minute, second);
            return cal;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    protected static Calendar str_to_cal(String s) {
        return TrendServlet.str_to_cal(s, "-");
    }

    protected static Calendar rad_to_cal(Calendar cal, String s) {
        if (!s.equals("n")) {
            if (s.equals("h")) {
                cal.add(11, -1);
            } else if (s.equals("d")) {
                cal.add(5, -1);
            } else if (s.equals("w")) {
                cal.add(5, -7);
            } else if (s.equals("m")) {
                cal.add(2, -1);
            } else if (s.equals("q")) {
                cal.add(2, -3);
            } else if (s.equals("y")) {
                cal.add(1, -1);
            } else {
                return null;
            }
        }
        return cal;
    }

    protected InputStream dsStream(String ds) throws IOException {
        String fn = this.getInitParameter("datasources." + ds);
        if (fn == null) {
            throw new IOException("no datasources." + ds + " property");
        }
        if (fn.startsWith("http:")) {
            try {
                URL url = new URL(fn);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                if (uc.getContentLength() != 0) {
                    return uc.getInputStream();
                }
                throw new IOException("No content");
            }
            catch (MalformedURLException ex) {
                throw new IOException("Bad URL: " + ex.getMessage());
            }
        }
        File f = new File(fn);
        FileInputStream fis = new FileInputStream(f);
        return fis;
    }

    protected void sendHeader(HttpServletResponse resp, String type) throws IOException {
        resp.setContentType("text/html");
        ServletOutputStream os = resp.getOutputStream();
        Object title = "Trend Server";
        if (this.name != null) {
            title = (String)title + " - " + TrendServlet.encodeHTML(this.name);
        }
        if (type != null) {
            title = (String)title + " - " + TrendServlet.encodeHTML(type);
        }
        os.println("<HTML>");
        os.println("<HEAD>");
        os.println("<TITLE>" + (String)title + "</TITLE>");
        os.println("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"default.css\" MEDIA=\"all\">");
        os.println("</HEAD>");
        os.println("<BODY>");
        os.println("<BASEFONT SIZE=3>");
        os.println("<TABLE><TR><TH><FONT SIZE=+2>" + (String)title + "</FONT></TABLE>");
        os.println();
    }

    protected static void sendTrailer(HttpServletResponse resp) throws IOException {
        ServletOutputStream os = resp.getOutputStream();
        os.println();
        os.println("</BODY>");
        os.println("</HTML>");
    }

    protected void sendUsage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.sendHeader(resp, "usage");
        ServletOutputStream os = resp.getOutputStream();
        os.println("<P>TrendServlet can be used to trend information");
        os.println("<P>Usage:");
        os.println("<P>");
        os.println("<PRE>");
        String uri = req.getRequestURI();
        os.println("  http://hostname" + TrendServlet.encodeHTML(uri) + "[?options]");
        os.println("</PRE>");
        os.println("<P>Where options include:");
        os.println("<P>");
        os.println("<UL>");
        os.println("<LI><CODE>a</CODE> is the action (main, graph, samples or samples.csv, main is the default)");
        os.println("<LI><CODE>ds</CODE> is the data source(s)");
        os.println("<LI><CODE>r</CODE> is the resource(s)");
        os.println("<LI><CODE>st</CODE> is the start time (default to a day before end time)");
        os.println("<LI><CODE>et</CODE> is the end time (default is now)");
        os.println("<LI><CODE>w</CODE> is graph width");
        os.println("<LI><CODE>h</CODE> is graph height");
        os.println("</UL>");
        TrendServlet.sendTrailer(resp);
    }

    protected void sendError(HttpServletResponse resp, String error) throws IOException {
        this.sendHeader(resp, "error");
        ServletOutputStream os = resp.getOutputStream();
        os.println("<P>" + TrendServlet.encodeHTML(error));
        TrendServlet.sendTrailer(resp);
    }

    protected void sendSamples(HttpServletRequest req, HttpServletResponse resp, String[] ds_a) throws IOException {
        if (ds_a == null || ds_a.length != 1) {
            this.sendError(resp, "ds=datasource parameter required");
            return;
        }
        String ds = ds_a[0];
        try {
            String line;
            InputStream is = this.dsStream(ds);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            ServletOutputStream os = resp.getOutputStream();
            resp.setContentType("text/plain");
            while ((line = br.readLine()) != null) {
                os.println(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            resp.sendError(500);
        }
    }

    protected static String sanitize(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSamplesCsv(HttpServletResponse resp, String[] ds_a, String[] r_a, Calendar st_cal, Calendar et_cal) throws IOException {
        long et_m;
        if (ds_a == null || ds_a.length != 1 || r_a == null || r_a.length != 1) {
            this.sendError(resp, "ds=datasource and r=resource parameters required");
            return;
        }
        String ds = ds_a[0];
        String r = r_a[0];
        int inx = this.r_all.indexOf(r);
        if (inx == -1) {
            this.sendError(resp, "Unrecognised resource: " + r);
            return;
        }
        long st_m = st_cal.getTime().getTime();
        if (st_m + 60000L > (et_m = et_cal.getTime().getTime())) {
            this.sendError(resp, "Timespan must cover at least one minute");
            return;
        }
        resp.setContentType("application/csv");
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + TrendServlet.sanitize(ds) + "_" + TrendServlet.sanitize(r) + "_" + TrendServlet.cal_to_str(st_cal) + "_" + TrendServlet.cal_to_str(et_cal) + ".csv\"");
        ServletOutputStream os = resp.getOutputStream();
        Vector<String> c_all = this.getInitParameterVector("consumers." + ds);
        int nConsumers = c_all.size();
        Vector<String> c_ignore = this.getInitParameterVector("consumers-ignore." + ds);
        os.print("datetime");
        for (String c : c_all) {
            os.print("," + c);
        }
        os.println();
        Object object = this;
        synchronized (object) {
            Vector<Sample> samples;
            try {
                samples = this.getSamples(ds, c_all, c_ignore);
            }
            catch (IOException ioe) {
                return;
            }
            int sFirst = this.locateAfter(samples, st_cal);
            int sLast = this.locateAfter(samples, et_cal);
            if (sFirst > 0) {
                --sFirst;
            }
            if (sLast < samples.size() - 2) {
                ++sLast;
            }
            for (int s = sFirst; s < sLast - 1; ++s) {
                Sample s1 = samples.elementAt(s);
                os.print(TrendServlet.cal_to_str_csv(s1.cal));
                for (int c = 0; c < nConsumers; ++c) {
                    os.print("," + s1.values[c][inx]);
                }
                os.println();
            }
        }
    }

    protected Vector<Sample> readSamples(InputStream is, Vector<String> c_all, Vector<String> c_ignore) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        Vector<Sample> samples = new Vector<Sample>(1000, 1000);
        String line = br.readLine();
        while (line != null && line.charAt(0) == '\t') {
            line = br.readLine();
        }
        int ic_other = c_all.indexOf("other");
        int nConsumers = c_all.size();
        while (line != null) {
            Calendar cal = TrendServlet.str_to_cal(line, " \t");
            if (cal != null) {
                Sample sample = new Sample(cal, nConsumers);
                line = br.readLine();
                while (line != null && line.charAt(0) == '\t') {
                    int ic;
                    StringTokenizer st = new StringTokenizer(line);
                    String c = st.nextToken();
                    if (TrendServlet.matches(c, c_ignore) == -1 && ((ic = TrendServlet.matches(c, c_all)) != -1 || (ic = ic_other) != -1)) {
                        for (int i = 0; i < this.nResources && st.hasMoreTokens(); ++i) {
                            float[] fArray = sample.values[ic];
                            int n = i;
                            fArray[n] = fArray[n] + this.toFloat(st.nextToken(), 0.0f) * this.multipliers[i];
                        }
                    }
                    line = br.readLine();
                }
                samples.add(sample);
                continue;
            }
            line = br.readLine();
            while (line != null && line.charAt(0) == '\t') {
                line = br.readLine();
            }
        }
        return samples;
    }

    protected Vector<Sample> getSamples(String ds, Vector<String> c_all, Vector<String> c_ignore) throws IOException {
        Vector<Sample> samples = this.samplesHash.get(ds);
        if (samples == null) {
            try (InputStream is = this.dsStream(ds);){
                samples = this.readSamples(is, c_all, c_ignore);
                this.samplesHash.put(ds, samples);
            }
        }
        return samples;
    }

    protected void dropSamples(String ds) {
        this.samplesHash.remove(ds);
    }

    protected int divWidth(Calendar cal, long st_m, long et_m, int field, int xs) {
        Calendar cal2 = this.cloneCalendar(cal);
        cal2.add(field, 1);
        long m = cal2.getTime().getTime();
        return (int)((long)xs * (m - st_m) / (et_m - st_m));
    }

    protected void divSeconds(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(13, 1);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if (cal.get(13) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(13, 1);
        }
    }

    protected void valSeconds(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(13, 1);
        g.setColor(colorText);
        while (cal.before(et_cal)) {
            if (cal.get(13) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                int s = cal.get(13);
                g.drawString((s < 10 ? "0" : "") + Integer.toString(s) + "s", xo + x, yo + ys);
            }
            cal.add(13, 1);
        }
    }

    protected void divMinutes(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(12, 1);
        cal.add(13, -1);
        cal.set(13, 0);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if (cal.get(12) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(12, 1);
        }
    }

    protected void valMinutes(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(12, 1);
        cal.add(13, -1);
        cal.set(13, 0);
        g.setColor(colorText);
        while (cal.before(et_cal)) {
            if (cal.get(12) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                int moh = cal.get(12);
                g.drawString((moh < 10 ? "0" : "") + Integer.toString(moh) + "m", xo + x, yo + ys);
            }
            cal.add(12, 1);
        }
    }

    protected void divHours(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(11, 1);
        cal.add(13, -1);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if (cal.get(11) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(11, 1);
        }
    }

    protected void valHours(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(11, 1);
        cal.add(13, -1);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorText);
        while (cal.before(et_cal)) {
            if (cal.get(11) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                int hod = cal.get(11);
                g.drawString((hod < 10 ? "0" : "") + Integer.toString(hod) + "h", xo + x, yo + ys);
            }
            cal.add(11, 1);
        }
    }

    protected void divDays(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(5, 1);
        cal.add(13, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if ((cal.get(5) - 1) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(5, 1);
        }
    }

    protected void valDays(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(5, 1);
        cal.add(13, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorText);
        while (cal.before(et_cal)) {
            if ((cal.get(5) - 1) % step == 0) {
                String suffix;
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                int dom = cal.get(5);
                switch (dom) {
                    case 1: 
                    case 21: 
                    case 31: {
                        suffix = "st";
                        break;
                    }
                    case 2: 
                    case 22: {
                        suffix = "nd";
                        break;
                    }
                    case 3: 
                    case 23: {
                        suffix = "rd";
                        break;
                    }
                    default: {
                        suffix = "th";
                    }
                }
                g.drawString(Integer.toString(dom) + suffix, xo + x, yo + ys);
            }
            cal.add(5, 1);
        }
    }

    protected void divMonths(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(2, 1);
        cal.add(13, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if ((cal.get(2) - 0) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(2, 1);
        }
    }

    protected void valMonths(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(2, 1);
        cal.add(13, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorText);
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        while (cal.before(et_cal)) {
            if ((cal.get(2) - 0) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.drawString(months[cal.get(2) - 0], xo + x, yo + ys);
            }
            cal.add(2, 1);
        }
    }

    protected void divYears(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step, int lw) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(1, 1);
        cal.add(13, -1);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorGrid);
        while (cal.before(et_cal)) {
            if (cal.get(2) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.fillRect(xo + x, yo, lw, ys);
            }
            cal.add(1, 1);
        }
    }

    protected void valYears(Graphics g, int xo, int yo, int xs, int ys, Calendar st_cal, long st_m, Calendar et_cal, long et_m, int step) {
        Calendar cal = this.cloneCalendar(st_cal);
        cal.add(1, 1);
        cal.add(13, -1);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        g.setColor(colorText);
        while (cal.before(et_cal)) {
            if (cal.get(2) % step == 0) {
                long m = cal.getTime().getTime();
                int x = (int)((long)xs * (m - st_m) / (et_m - st_m));
                g.drawString(Integer.toString(cal.get(1)), xo + x, yo + ys);
            }
            cal.add(1, 1);
        }
    }

    protected int locateAfter(Vector<Sample> samples, Calendar cal) {
        int iLo = 0;
        int iHi = samples.size();
        while (iLo < iHi) {
            int iMid = (iLo + iHi) / 2;
            Sample sMid = samples.elementAt(iMid);
            if (cal.before(sMid.cal)) {
                iHi = iMid;
                continue;
            }
            if (cal.after(sMid.cal)) {
                iLo = iMid + 1;
                continue;
            }
            return iMid;
        }
        return iLo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendGraph(HttpServletRequest req, HttpServletResponse resp, String[] ds_a, String[] r_a, Calendar st_cal, Calendar et_cal, boolean split, boolean scale, boolean squeeze, int w, int h) throws IOException {
        long et_m;
        if (ds_a == null || ds_a.length != 1 || r_a == null || r_a.length != 1) {
            this.sendError(resp, "ds=datasource and r=resource parameters required");
            return;
        }
        String ds = ds_a[0];
        String r = r_a[0];
        int inx = this.r_all.indexOf(r);
        if (inx == -1) {
            this.sendError(resp, "Unrecognised resource: " + r);
            return;
        }
        long st_m = st_cal.getTime().getTime();
        if (st_m + 60000L > (et_m = et_cal.getTime().getTime())) {
            this.sendError(resp, "Timespan must cover at least one minute");
            return;
        }
        Vector<String> c_all = this.getInitParameterVector("consumers." + ds);
        int nConsumers = c_all.size();
        Vector<String> c_ignore = this.getInitParameterVector("consumers-ignore." + ds);
        String tot = this.getInitParameter("resources." + ds + "." + r + ".total");
        if (tot == null && (tot = this.getInitParameter("resources." + r + ".total")) == null) {
            tot = "";
        }
        float total = this.toFloat(tot, 100.0f);
        String units = this.getInitParameter("resources." + ds + "." + r + ".units");
        if (units == null && (units = this.getInitParameter("resources." + r + ".units")) == null) {
            units = "";
        }
        int interval = this.toInt(this.getInitParameter("interval." + ds), 65) * 1000;
        Frame fr = new Frame();
        fr.addNotify();
        Image image = fr.createImage(w, h);
        Graphics g = image.getGraphics();
        int bw = 4;
        int bh = 4;
        FontMetrics fm = g.getFontMetrics();
        String adhoc = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int cw = fm.stringWidth(adhoc) / 62;
        int ch = fm.getHeight();
        int th = ch + bh;
        int nw = 0;
        for (int c = 0; c < nConsumers; ++c) {
            int nw2 = fm.stringWidth(c_all.elementAt(c));
            if (nw2 <= nw) continue;
            nw = nw2;
        }
        TrendServlet c = this;
        synchronized (c) {
            int step;
            int i;
            int vy;
            int step2;
            int i2;
            Vector<Sample> samples;
            try {
                samples = this.getSamples(ds, c_all, c_ignore);
            }
            catch (IOException ioe) {
                this.sendError(resp, ioe.getMessage());
                return;
            }
            int sFirst = this.locateAfter(samples, st_cal);
            int sLast = this.locateAfter(samples, et_cal);
            if (sFirst > 0) {
                --sFirst;
            }
            if (sLast < samples.size() - 2) {
                ++sLast;
            }
            if (scale || total < 0.0f) {
                total = 0.0f;
                for (int s = sFirst; s < sLast - 1; ++s) {
                    Sample s1 = samples.elementAt(s);
                    float y = 0.0f;
                    for (int c2 = 0; c2 < nConsumers; ++c2) {
                        y += s1.values[c2][inx];
                    }
                    total = Math.max(total, y);
                }
            }
            float[] ents = new float[nConsumers];
            for (int c3 = 0; c3 < nConsumers; ++c3) {
                String c2 = c_all.elementAt(c3);
                String e = this.getInitParameter("entitlement." + ds + "." + r + "." + c2);
                if (e == null && (e = this.getInitParameter("entitlement." + r + "." + c2)) == null) {
                    e = "";
                }
                ents[c3] = this.toFloat(e, -1.0f);
            }
            float sum = 0.0f;
            int nEnts = 0;
            for (int c4 = 0; c4 < nConsumers; ++c4) {
                if (!(ents[c4] >= 0.0f)) continue;
                sum += ents[c4];
                ++nEnts;
            }
            if (sum > total) {
                total = sum;
            }
            float[] yents = new float[nConsumers];
            for (int c5 = 0; c5 < nConsumers; ++c5) {
                yents[c5] = ents[c5] >= 0.0f ? ents[c5] : (total - sum) / (float)(nConsumers - nEnts);
            }
            int mw = fm.stringWidth(Integer.toString((int)total) + units);
            int mh = 2 * ch;
            int gw = w - bw - nw - bw - mw - bw;
            int gh = h - bh - th - bh - mh - bh;
            g.setColor(colorBitmap);
            g.fillRect(0, 0, w, h);
            g.setColor(colorGraph);
            g.fillRect(bw + nw + bw + mw + bw, bh + th + bh, gw, gh);
            for (int c6 = 0; c6 < nConsumers; ++c6) {
                g.setColor(colorConsumers[c6 % colorConsumers.length]);
                g.drawString(c_all.elementAt(c6), bw, bh + th + bh + gh - gh * c6 / nConsumers);
            }
            int divsMax = gh / ch;
            float vdiv = 1.0f;
            while (!(total / vdiv <= (float)divsMax || total / (vdiv = (float)((double)vdiv * 2.0)) <= (float)divsMax || total / (vdiv = (float)((double)vdiv * 2.5)) <= (float)divsMax)) {
                vdiv = (float)((double)vdiv * 2.0);
            }
            for (float v = 0.0f; v <= total; v += vdiv) {
                int y = (int)((float)gh * (v / total));
                g.setColor(colorText);
                String vs = Integer.toString((int)v) + units;
                int sw = fm.stringWidth(vs);
                g.drawString(vs, bw + nw + bw + mw - sw, bh + th + bh + gh - y - 1);
                g.setColor(colorGrid);
                g.fillRect(bw + nw + bw + mw + bw, bh + th + bh + gh - y - 1, gw, 1);
            }
            int tdwYear = this.divWidth(st_cal, st_m, et_m, 1, gw);
            int tdwMonth = this.divWidth(st_cal, st_m, et_m, 2, gw);
            int tdwDay = this.divWidth(st_cal, st_m, et_m, 5, gw);
            int tdwHour = this.divWidth(st_cal, st_m, et_m, 11, gw);
            int tdwMinute = this.divWidth(st_cal, st_m, et_m, 12, gw);
            int tdwSecond = this.divWidth(st_cal, st_m, et_m, 13, gw);
            int[] stepSeconds = new int[]{5, 15, 30};
            int[] stepMinutes = new int[]{1, 5, 15, 30};
            int[] stepHours = new int[]{1, 3, 6, 12};
            int[] stepDays = new int[]{1, 7};
            int[] stepMonths = new int[]{1, 3, 6};
            int[] stepYears = new int[]{1, 10, 100, 1000};
            int tdwMin = 20;
            int lw = 1;
            for (i2 = 0; i2 < stepSeconds.length; ++i2) {
                step2 = stepSeconds[i2];
                if (tdwSecond * step2 < tdwMin) continue;
                this.divSeconds(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            for (i2 = 0; i2 < stepMinutes.length; ++i2) {
                step2 = stepMinutes[i2];
                if (tdwMinute * step2 < tdwMin) continue;
                this.divMinutes(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            for (i2 = 0; i2 < stepHours.length; ++i2) {
                step2 = stepHours[i2];
                if (tdwHour * step2 < tdwMin) continue;
                this.divHours(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            for (i2 = 0; i2 < stepDays.length; ++i2) {
                step2 = stepDays[i2];
                if (tdwDay * step2 < tdwMin) continue;
                this.divDays(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            for (i2 = 0; i2 < stepMonths.length; ++i2) {
                step2 = stepMonths[i2];
                if (tdwMonth * step2 < tdwMin) continue;
                this.divMonths(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            for (i2 = 0; i2 < stepYears.length; ++i2) {
                step2 = stepYears[i2];
                if (tdwYear * step2 < tdwMin) continue;
                this.divYears(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh, st_cal, st_m, et_cal, et_m, step2, lw++);
                break;
            }
            if ((vy = ch) <= mh) {
                for (i = 0; i < stepSeconds.length; ++i) {
                    step = stepSeconds[i];
                    if (tdwSecond * step < 4 * cw) continue;
                    this.valSeconds(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    vy += ch;
                    break;
                }
            }
            if (vy <= mh) {
                for (i = 0; i < stepMinutes.length; ++i) {
                    step = stepMinutes[i];
                    if (tdwMinute * step < 4 * cw) continue;
                    this.valMinutes(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    vy += ch;
                    break;
                }
            }
            if (vy <= mh) {
                for (i = 0; i < stepHours.length; ++i) {
                    step = stepHours[i];
                    if (tdwHour * step < 4 * cw) continue;
                    this.valHours(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    vy += ch;
                    break;
                }
            }
            if (vy <= mh) {
                for (i = 0; i < stepDays.length; ++i) {
                    step = stepDays[i];
                    if (tdwDay * step < 5 * cw) continue;
                    this.valDays(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    vy += ch;
                    break;
                }
            }
            if (vy <= mh) {
                for (i = 0; i < stepMonths.length; ++i) {
                    step = stepMonths[i];
                    if (tdwMonth * step < 4 * cw) continue;
                    this.valMonths(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    vy += ch;
                    break;
                }
            }
            if (vy <= mh) {
                for (i = 0; i < stepYears.length; ++i) {
                    step = stepYears[i];
                    if (tdwYear * step < 5 * cw) continue;
                    this.valYears(g, bw + nw + bw + mw + bw, bh + th + bh, gw, gh + vy, st_cal, st_m, et_cal, et_m, step);
                    break;
                }
            }
            float[] ys = new float[nConsumers];
            float[] hs = new float[nConsumers];
            for (int s = sFirst; s < sLast - 1; ++s) {
                float highest;
                int c7;
                float y;
                int x2;
                Sample s1 = samples.elementAt(s);
                long m1 = s1.cal.getTime().getTime();
                int x1 = (int)((long)gw * (m1 - st_m) / (et_m - st_m));
                if (x1 < 0) {
                    x1 = 0;
                }
                Sample s2 = samples.elementAt(s + 1);
                long m2 = s2.cal.getTime().getTime();
                if (m2 > m1 + (long)interval) {
                    m2 = m1 + (long)interval;
                }
                if (x1 == (x2 = (int)((long)gw * (m2 - st_m) / (et_m - st_m)))) {
                    ++x2;
                }
                if (x2 > gw) {
                    x2 = gw;
                }
                if (split) {
                    y = 0.0f;
                    float y2 = 0.0f;
                    for (int c8 = 0; c8 < nConsumers; ++c8) {
                        ys[c8] = Math.max(y, y2);
                        hs[c8] = s1.values[c8][inx];
                        y2 = ys[c8] + hs[c8];
                        y += yents[c8];
                    }
                    if (nConsumers >= 2) {
                        while (ys[nConsumers - 1] + hs[nConsumers - 1] > total) {
                            int c9;
                            float gap = 0.0f;
                            for (c9 = nConsumers - 1; c9 > 0 && !((gap = ys[c9] - (ys[c9 - 1] + hs[c9 - 1])) > 0.0f); --c9) {
                            }
                            if (c9 != 0) {
                                while (c9 < nConsumers) {
                                    int n = c9++;
                                    ys[n] = ys[n] - gap;
                                }
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    y = 0.0f;
                    for (c7 = 0; c7 < nConsumers; ++c7) {
                        ys[c7] = y;
                        hs[c7] = s1.values[c7][inx];
                        y += hs[c7];
                    }
                }
                float factor = 1.0f;
                if (nConsumers > 0 && (highest = ys[nConsumers - 1] + hs[nConsumers - 1]) > total && squeeze) {
                    factor = total / highest;
                    g.setColor(colorSqueezed);
                    g.fillRect(bw + nw + bw + mw + bw + x1, bh + th + bh - 4, x2 - x1, 2);
                }
                for (c7 = 0; c7 < nConsumers; ++c7) {
                    int ytop = (int)((float)gh * ((ys[c7] + hs[c7]) * factor / total));
                    int ybot = (int)((float)gh * (ys[c7] * factor / total));
                    g.setColor(colorConsumers[c7 % colorConsumers.length]);
                    g.fillRect(bw + nw + bw + mw + bw + x1, bh + th + bh + gh - ytop, x2 - x1, ytop - ybot);
                    if (!(ents[c7] >= 0.0f) || !(hs[c7] > ents[c7])) continue;
                    int y2 = (int)((float)gh * ((ys[c7] + ents[c7]) * factor / total));
                    g.setColor(colorConsumersExceed[c7 % colorConsumers.length]);
                    g.fillRect(bw + nw + bw + mw + bw + x1, bh + th + bh + gh - y2 - 1, x2 - x1, 2);
                }
            }
            int gtx = bw + nw + bw + mw + bw;
            int gth = ch + fm.getDescent();
            int gtw = fm.stringWidth(ds);
            g.setColor(colorTitleBg);
            g.fillRect(gtx, bh, bw + gtw + bw, gth);
            g.setColor(colorText);
            g.drawString(ds, gtx + bw, bh + ch);
            gtx += bw + gtw + bw + bw;
            gtw = fm.stringWidth(r);
            g.setColor(colorTitleBg);
            g.fillRect(gtx, bh, bw + gtw + bw, gth);
            g.setColor(colorText);
            g.drawString(r, gtx + bw, bh + ch);
            gtx += bw + gtw + bw + bw;
            String ival = TrendServlet.cal_to_str(st_cal) + " to " + TrendServlet.cal_to_str(et_cal);
            gtw = fm.stringWidth(ival);
            g.setColor(colorTitleBg);
            g.fillRect(gtx, bh, bw + gtw + bw, gth);
            g.setColor(colorText);
            g.drawString(ival, gtx + bw, bh + ch);
            String label = this.getInitParameter("datasources." + ds + ".label");
            if (label != null) {
                gtx += bw + gtw + bw + bw;
                gtw = fm.stringWidth(label);
                g.setColor(colorTitleBg);
                g.fillRect(gtx, bh, bw + gtw + bw, gth);
                g.setColor(colorText);
                g.drawString(label, gtx + bw, bh + ch);
            }
        }
        ServletOutputStream os = resp.getOutputStream();
        resp.setContentType("image/png");
        new PngEncoder(image).encode((OutputStream)os);
    }

    protected String statsRow(Color col, String consumer, float min, float max, float range, float avg) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb, Locale.US);
        f.format("<TR><TD CLASS=\"stats-consumer\" STYLE=\"color:#%02X%02X%02X\">%s<TD CLASS=\"stats-value\">%4.2f<TD CLASS=\"stats-value\">%4.2f<TD CLASS=\"stats-value\">%4.2f<TD CLASS=\"stats-value\">%4.2f", col.getRed(), col.getGreen(), col.getBlue(), TrendServlet.encodeHTML(consumer), Float.valueOf(min), Float.valueOf(max), Float.valueOf(range), Float.valueOf(avg));
        return f.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStats(HttpServletResponse resp, String ds, String r, Calendar st_cal, Calendar et_cal) throws IOException {
        long et_m;
        Vector<String> c_all = this.getInitParameterVector("consumers." + ds);
        int nConsumers = c_all.size();
        Vector<String> c_ignore = this.getInitParameterVector("consumers-ignore." + ds);
        int interval = this.toInt(this.getInitParameter("interval." + ds), 65) * 1000;
        int inx = this.r_all.indexOf(r);
        if (inx == -1) {
            return;
        }
        long st_m = st_cal.getTime().getTime();
        if (st_m + 60000L > (et_m = et_cal.getTime().getTime())) {
            return;
        }
        float[] mins = new float[nConsumers];
        float[] maxs = new float[nConsumers];
        float[] totals = new float[nConsumers];
        float summin = Float.POSITIVE_INFINITY;
        float summax = 0.0f;
        float sumtotal = 0.0f;
        float total_time = 0.0f;
        for (int c = 0; c < nConsumers; ++c) {
            mins[c] = Float.POSITIVE_INFINITY;
        }
        TrendServlet c = this;
        synchronized (c) {
            Vector<Sample> samples;
            try {
                samples = this.getSamples(ds, c_all, c_ignore);
            }
            catch (IOException ioe) {
                return;
            }
            int sFirst = this.locateAfter(samples, st_cal);
            int sLast = this.locateAfter(samples, et_cal);
            if (sFirst > 0) {
                --sFirst;
            }
            if (sLast < samples.size() - 2) {
                ++sLast;
            }
            for (int s = sFirst; s < sLast - 1; ++s) {
                Sample s1 = samples.elementAt(s);
                long m1 = s1.cal.getTime().getTime();
                Sample s2 = samples.elementAt(s + 1);
                long m2 = s2.cal.getTime().getTime();
                if (m2 > m1 + (long)interval) {
                    m2 = m1 + (long)interval;
                }
                if (m1 < st_m) {
                    m1 = st_m;
                } else if (m1 > et_m) {
                    m1 = et_m;
                }
                if (m2 < st_m) {
                    m2 = st_m;
                } else if (m2 > et_m) {
                    m2 = et_m;
                }
                float sumv = 0.0f;
                int c2 = 0;
                while (c2 < nConsumers) {
                    float v = s1.values[c2][inx];
                    if (v < mins[c2]) {
                        mins[c2] = v;
                    }
                    if (v > maxs[c2]) {
                        maxs[c2] = v;
                    }
                    int n = c2++;
                    totals[n] = totals[n] + v * (float)(m2 - m1);
                    sumv += v;
                }
                if (sumv < summin) {
                    summin = sumv;
                }
                if (sumv > summax) {
                    summax = sumv;
                }
                sumtotal += sumv * (float)(m2 - m1);
                total_time += (float)(m2 - m1);
            }
        }
        if (total_time == 0.0f) {
            return;
        }
        ServletOutputStream os = resp.getOutputStream();
        os.println("<TABLE>");
        os.println("<TR><TH CLASS=\"stats-consumer\">Consumer<TH CLASS=\"stats-value\">Min<TH CLASS=\"stats-value\">Max<TH CLASS=\"stats-value\">Range<TH CLASS=\"stats-value\">Avg");
        for (int c3 = nConsumers - 1; c3 >= 0; --c3) {
            os.println(this.statsRow(colorConsumers[c3 % colorConsumers.length], c_all.elementAt(c3), mins[c3], maxs[c3], maxs[c3] - mins[c3], totals[c3] / total_time));
        }
        os.println(this.statsRow(Color.black, "Total", summin, summax, summax - summin, sumtotal / total_time));
        os.println("</TABLE>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMain(HttpServletRequest req, HttpServletResponse resp, String[] ds_a, String[] r_a, Calendar st_cal, Calendar et_cal, boolean split, boolean scale, boolean squeeze, boolean stats, boolean samples, int w, int h, boolean refresh) throws IOException {
        String ds;
        int i;
        String t4;
        String t3;
        String t2;
        String t1;
        String ua;
        this.sendHeader(resp, null);
        ServletOutputStream os = resp.getOutputStream();
        String uri = req.getRequestURI();
        Vector<String> ds_show = new Vector<String>();
        if (ds_a != null) {
            for (int i2 = 0; i2 < ds_a.length; ++i2) {
                ds_show.add(ds_a[i2]);
            }
        }
        Vector<String> r_show = new Vector<String>();
        if (r_a != null) {
            for (int i3 = 0; i3 < r_a.length; ++i3) {
                r_show.add(r_a[i3]);
            }
        }
        String st_str = TrendServlet.cal_to_str(st_cal);
        String et_str = TrendServlet.cal_to_str(et_cal);
        if (refresh) {
            for (int i4 = 0; i4 < ds_show.size(); ++i4) {
                String ds2 = (String)ds_show.elementAt(i4);
                TrendServlet trendServlet = this;
                synchronized (trendServlet) {
                    this.dropSamples(ds2);
                    continue;
                }
            }
        }
        if ((ua = req.getHeader("User-Agent")) != null && ua.indexOf("Mozilla/4") != -1 && ua.indexOf("MSIE") == -1) {
            t1 = "";
            t2 = "<BR>";
            t3 = "";
            t4 = "";
        } else {
            t1 = "<TABLE>";
            t2 = "<TR><TD>";
            t3 = "<TD>";
            t4 = "</TABLE>";
        }
        os.println(t1);
        for (i = 0; i < ds_show.size(); ++i) {
            ds = (String)ds_show.elementAt(i);
            for (int j = 0; j < r_show.size(); ++j) {
                String r = (String)r_show.elementAt(j);
                os.println(t2 + "<IMG SRC=\"" + TrendServlet.encodeHTML(uri) + "?a=graph&ds=" + TrendServlet.encodeHTML(ds) + "&r=" + TrendServlet.encodeHTML(r) + "&st=" + st_str + "&et=" + et_str + (split ? "&split=on" : "") + (scale ? "&scale=on" : "") + (squeeze ? "&squeeze=on" : "") + "&w=" + w + "&h=" + h + "\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\">");
                if (stats) {
                    os.println(t3);
                    this.sendStats(resp, ds, r, st_cal, et_cal);
                }
                if (!samples) continue;
                os.println(t3);
                os.println("<FORM ACTION=\"" + TrendServlet.encodeHTML(uri) + "\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"a\" VALUE=\"samples\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ds\" VALUE=\"" + TrendServlet.encodeHTML(ds) + "\">");
                os.println("<INPUT CLASS=\"BUTTON\" TYPE=\"SUBMIT\" VALUE=\"Source\">");
                os.println("</FORM>");
                os.println("<FORM ACTION\"" + TrendServlet.encodeHTML(uri) + "\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"a\" VALUE=\"samples.csv\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ds\" VALUE=\"" + TrendServlet.encodeHTML(ds) + "\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"r\" VALUE=\"" + TrendServlet.encodeHTML(r) + "\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"st\" VALUE=\"" + st_str + "\">");
                os.println("<INPUT TYPE=\"HIDDEN\" NAME=\"et\" VALUE=\"" + et_str + "\">");
                os.println("<INPUT CLASS=\"BUTTON\" TYPE=\"SUBMIT\" VALUE=\"CSV\">");
                os.println("</FORM>");
            }
        }
        os.println(t4);
        if (ds_show.size() == 0 || r_show.size() == 0) {
            os.println("<P>Please select the graphs you'd like to see from the form below.</P>");
        }
        os.println("<FORM NAME=\"choiceForm\" ACTION=\"" + TrendServlet.encodeHTML(uri) + "\">");
        os.println("  <TABLE>");
        os.println("    <TR><TH>Datasource(s)<TH>Resource(s)<TH>From<TH>To<TH>Options<TH>Width<TH>Height");
        os.println("    <TR>");
        os.println("      <TD VALIGN=TOP>");
        os.println("        <SELECT NAME=\"ds\" MULTIPLE SIZE=\"" + Math.min(this.nDatasources, 10) + "\">");
        for (i = 0; i < this.ds_all.size(); ++i) {
            ds = this.ds_all.elementAt(i);
            os.print("          <OPTION VALUE=\"" + TrendServlet.encodeHTML(ds) + "\"");
            if (ds_show.contains(ds)) {
                os.print(" SELECTED");
            }
            os.println(">" + TrendServlet.encodeHTML(ds));
        }
        os.println("        </SELECT>");
        os.println("      <TD VALIGN=TOP>");
        os.println("        <SELECT NAME=\"r\" MULTIPLE SIZE=\"" + Math.min(this.nResources, 10) + "\">");
        for (i = 0; i < this.r_all.size(); ++i) {
            String r = this.r_all.elementAt(i);
            os.print("          <OPTION VALUE=\"" + TrendServlet.encodeHTML(r) + "\"");
            if (r_show.contains(r)) {
                os.print(" SELECTED");
            }
            os.println(">" + TrendServlet.encodeHTML(r));
        }
        os.println("        </SELECT>");
        os.println("      <TD VALIGN=TOP>");
        os.println("                     <INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"\" onClick=\"Est()\" CHECKED>");
        os.println("                     <INPUT TYPE=\"TEXT\" NAME=\"st\" VALUE=\"" + TrendServlet.encodeHTML(st_str) + "\">");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"h\" onClick=\"Dst()\"> hour before");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"d\" onClick=\"Dst()\"> day before");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"w\" onClick=\"Dst()\"> week before");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"m\" onClick=\"Dst()\"> month before");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"q\" onClick=\"Dst()\"> quarter before");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"str\" VALUE=\"y\" onClick=\"Dst()\"> year before");
        os.println("      <TD VALIGN=TOP>");
        os.println("                     <INPUT TYPE=\"RADIO\" NAME=\"etr\" VALUE=\"\" onClick=\"Eet()\" CHECKED>");
        os.println("                     <INPUT TYPE=\"TEXT\" NAME=\"et\" VALUE=\"" + TrendServlet.encodeHTML(et_str) + "\">");
        os.println("                 <BR><INPUT TYPE=\"RADIO\" NAME=\"etr\" VALUE=\"n\" onClick=\"Det()\"> now");
        os.println("      <TD VALIGN=TOP><INPUT TYPE=\"CHECKBOX\" NAME=\"split\"" + (split ? " CHECKED" : "") + ">Split");
        os.println("                 <BR><INPUT TYPE=\"CHECKBOX\" NAME=\"scale\"" + (scale ? " CHECKED" : "") + ">Scale");
        os.println("                 <BR><INPUT TYPE=\"CHECKBOX\" NAME=\"squeeze\"" + (squeeze ? " CHECKED" : "") + ">Squeeze");
        os.println("                 <BR><INPUT TYPE=\"CHECKBOX\" NAME=\"stats\"" + (stats ? " CHECKED" : "") + ">Stats");
        os.println("                 <BR><INPUT TYPE=\"CHECKBOX\" NAME=\"samples\"" + (samples ? " CHECKED" : "") + ">Samples");
        os.println("      <TD VALIGN=TOP><INPUT TYPE=\"TEXT\" NAME=\"w\" VALUE=\"" + w + "\" SIZE=\"5\">");
        os.println("      <TD VALIGN=TOP><INPUT TYPE=\"TEXT\" NAME=\"h\" VALUE=\"" + h + "\" SIZE=\"5\">");
        os.println("  </TABLE>");
        os.println("  <P>");
        os.println("  <INPUT CLASS=\"button\" TYPE=\"SUBMIT\" VALUE=\"Redraw\">");
        os.println("  <INPUT CLASS=\"button\" TYPE=\"SUBMIT\" VALUE=\"Refresh and Redraw\" NAME=\"refresh\">");
        os.println("  <INPUT CLASS=\"button\" TYPE=\"RESET\" onClick=\"Est();Eet()\">");
        os.println("</FORM>");
        Object help = "<P>Trend Server <A HREF=\"trendserver.htm\">documentation</A> is available";
        if (this.doclinkname != null && this.doclinkurl != null) {
            help = (String)help + " and also a link to <A HREF=\"" + TrendServlet.encodeHTML(this.doclinkurl) + "\">" + TrendServlet.encodeHTML(this.doclinkname) + "</A>";
        }
        os.println((String)help + ".");
        os.println("<SCRIPT LANGUAGE=\"JavaScript\"><!--");
        os.println("function Dst() { window.document.choiceForm.st.disabled=true; }");
        os.println("function Est() { window.document.choiceForm.st.disabled=false; }");
        os.println("function Det() { window.document.choiceForm.et.disabled=true; }");
        os.println("function Eet() { window.document.choiceForm.et.disabled=false; }");
        os.println("--></SCRIPT>");
        TrendServlet.sendTrailer(resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletConfig sc = this.getServletConfig();
        String a = req.getParameter("a");
        String[] ds_a = req.getParameterValues("ds");
        String[] r_a = req.getParameterValues("r");
        Calendar et_cal = null;
        String et_str = req.getParameter("etr");
        if (et_str != null && !et_str.equals("")) {
            et_cal = TrendServlet.rad_to_cal(Calendar.getInstance(), et_str);
        } else {
            et_str = req.getParameter("et");
            if (et_str != null) {
                et_cal = TrendServlet.str_to_cal(et_str);
            }
        }
        if (et_cal == null) {
            et_cal = Calendar.getInstance();
        }
        Calendar st_cal = null;
        String st_str = req.getParameter("str");
        if (st_str != null && !st_str.equals("")) {
            st_cal = TrendServlet.rad_to_cal(this.cloneCalendar(et_cal), st_str);
        } else {
            st_str = req.getParameter("st");
            if (st_str != null) {
                st_cal = TrendServlet.str_to_cal(st_str);
            }
        }
        if (st_cal == null) {
            st_cal = this.cloneCalendar(et_cal);
            st_cal.add(5, -1);
        }
        boolean split = req.getParameter("split") != null;
        boolean scale = req.getParameter("scale") != null;
        boolean squeeze = req.getParameter("squeeze") != null;
        boolean stats = req.getParameter("stats") != null;
        boolean samples = req.getParameter("samples") != null;
        boolean refresh = req.getParameter("refresh") != null;
        String w_str = req.getParameter("w");
        if (w_str == null) {
            w_str = this.getInitParameter("graph.w");
        }
        int w = this.toInt(w_str, 800);
        String h_str = req.getParameter("h");
        if (h_str == null) {
            h_str = this.getInitParameter("graph.h");
        }
        int h = this.toInt(h_str, 200);
        if (!st_cal.before(et_cal)) {
            this.sendError(resp, "Start time must be before end time");
        } else if (w < 100 || w > 4000 || h < 50 || h > 2000) {
            this.sendError(resp, "Bad graphic size, pick between 100x50 to 4000x2000");
        } else if (a == null || a.equals("main")) {
            this.sendMain(req, resp, ds_a, r_a, st_cal, et_cal, split, scale, squeeze, stats, samples, w, h, refresh);
        } else if (a.equals("graph")) {
            this.sendGraph(req, resp, ds_a, r_a, st_cal, et_cal, split, scale, squeeze, w, h);
        } else if (a.equals("samples")) {
            this.sendSamples(req, resp, ds_a);
        } else if (a.equals("samples.csv")) {
            this.sendSamplesCsv(resp, ds_a, r_a, st_cal, et_cal);
        } else {
            this.sendUsage(req, resp);
        }
    }

    public void init() throws ServletException {
        super.init();
        String propsfn = this.getServletConfig().getInitParameter("trend.propsfn");
        if (propsfn != null) {
            try {
                FileInputStream fis = new FileInputStream(propsfn);
                this.props = new Properties();
                this.props.load(fis);
            }
            catch (IOException e) {
                throw new ServletException("Can't load properties from " + propsfn + ": " + e.getMessage());
            }
        }
        this.name = this.getInitParameter("name");
        this.doclinkname = this.getInitParameter("doclink.name");
        this.doclinkurl = this.getInitParameter("doclink.url");
        this.ds_all = this.getInitParameterVector("datasources");
        this.nDatasources = this.ds_all.size();
        this.r_all = this.getInitParameterVector("resources");
        this.nResources = this.r_all.size();
        this.multipliers = new float[this.nResources];
        for (int i = 0; i < this.nResources; ++i) {
            this.multipliers[i] = this.toFloat(this.getInitParameter("resources." + this.r_all.elementAt(i) + ".multiplier"), 1.0f);
        }
    }

    class Sample {
        public Calendar cal;
        public float[][] values;

        public Sample(Calendar c, int nConsumers) {
            this.cal = c;
            this.values = new float[nConsumers][TrendServlet.this.nResources];
        }
    }
}

