/*

hashmap.h - Something like java.util.HashMap<K,V>

*/

#ifndef HASHMAP_H
#define	HASHMAP_H

#include <stdio.h>
#include <stdlib.h>

typedef int HM_BOOLEAN;
#define	HM_TRUE  1
#define	HM_FALSE 0

typedef struct _HASHMAP HASHMAP;

/* Create a new hash map.
   Pass init_size==0 if you want a default.
   Returns NULL if can't allocate memory. */
extern HASHMAP *hm_create(
	HM_BOOLEAN (*equal)(const void *, const void *),
	unsigned (*hashcode)(const void *),
	void * (*clone)(const void *),
	void (*free)(void *),
	void * (*clone_value)(const void *),
	void (*free_value)(void *),
	int init_size
	);

/* Delete a hash map. */
extern void hm_delete(HASHMAP *h);

/* Does hash map contain a key? */
extern HM_BOOLEAN hm_contains(HASHMAP *h, const void *k);

/* Return value for specified key */
extern const void *hm_get(HASHMAP *h, const void *k);

/* Add value for key to hashmap.
   Returns HM_FALSE if can't allocate memory. */
extern HM_BOOLEAN hm_put(HASHMAP *h, const void *k, const void *v);

/* Remove key from hashmap. */
extern void hm_remove(HASHMAP *h, const void *k);

/* Visit each key. */
extern void hm_visit(
	HASHMAP *h,
	void (*visit)(const void *, const void *, void *),
	void *context
	);

/* Purely for debugging */
extern void hm_debug(HASHMAP *h);

#endif
